%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     Minimax Regret in Practice - Four Examples on Treatment Choice    %%
%%                             Matlab Code                               %%
%%              by Patrick Eozenou, Javier Rivas and Karl Schlag         %%
%%                       2006 - Copyrights reserved                      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%----------Function that make things look more beautiful (2/2)-------------

function[probability_of_choosing_treatment_1] = f_beautiful_things_2(treatments, ...
    probability_of_choosing_treatment_1, probability_of_choosing_treatment_2, ...
    original_lower_interval, original_upper_interval, method, VA_trick, accuracy, cost_1, cost_2,...
    error, regret);

if method == 0;
    str_method = ('BAR');
else;
    str_method = ('PS');
end;
if VA_trick == 0;
    str_VA_trick = ('no');
else;
    str_VA_trick = ('yes');
end;
abc_treatment_1 = char(treatments(1,1));
abc_treatment_2 = char(treatments(2,1));

if error == 0;
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%----TREATMENTS----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp(' ');
    disp(['          Treatment 1 = ',abc_treatment_1,'          Treatment 2 = ',abc_treatment_2,' ']);
    disp(' ');   
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%----PARAMETERS----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp(' ');
    disp(['    Method: ',str_method,'     Correlated: ',str_VA_trick,'    Interval = [',...
        num2str(original_lower_interval),',',num2str(original_upper_interval),']    Accuracy = ',...
        num2str(accuracy),'']);
    disp(' ');
    disp(['          Cost tratment 1 = ',num2str(cost_1),'           Cost treatment 2 = ',num2str(cost_2),'']);
    disp(' ');
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----RESULTS----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp(' ');
    disp(['            Regret                              = ',num2str(regret),'']);
    disp(' ');
    disp(['            Probability of choosing treatment 1 = ',num2str(probability_of_choosing_treatment_1),'']);
    disp(' ');
    disp(['            Probability of choosing treatment 2 = ',num2str(probability_of_choosing_treatment_2),'']);
    disp(' ');
else;
    disp(['Total errors to be corrected = ',num2str(error),'']);
    disp(' ');
end;

nothing = 0;